package thinkbot;

import intelligence.Thought;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.util.ArrayList;
import thinkbot.ThinkBot;

public class RetreatThought extends Thought {
    private ArrayList<NavPoint> followPath = null;   
    private int pathCount = 0;
        
    public void setGoalUnreachable() {
        if (followPath != null && !followPath.isEmpty()) {
            getAgent().getNavigation().setNavPointUnreachable(
                    followPath.get(followPath.size() - 1));
            agent.log.info("Unreach " + followPath.get(followPath.size() - 1));
        }
    }
     
    @Override
    public void think() {
        getAgent().resetStuck();
        getAgent().setHigherLevelGoals(null, null);
        if (intelligence.fullLogging) {
            agent.log.info("Retreat: health " + agent.getMemory().getHealth().getFlag().intValue()
                + ", ammo: " + agent.getMemory().getAgentAmmo() + "/" + agent.getMemory().getAgentAlternativeAmmo());
        }
        if (agent.getMemory().getAgentAmmo() == 0 && agent.getMemory().getAgentAlternativeAmmo() == 0) {
            //find any ammo or weapon
            if (intelligence.fullLogging) {
                agent.log.info("Searching for ammo...");
            }            
        } else {
            //find nearest health
            if (intelligence.fullLogging) {
                agent.log.info("Searching for health...");
            }
            NavPoint here = getAgent().getNavigation().getNearestNavPoint(getAgent().getMemory().getAgentLocation());
            NavPoint there = getAgent().getNavigation().getNearestHealth(here, false);
            if (there == null) {
                if (intelligence.fullLogging) {
                    agent.log.info("No health found.");
                }
                return;
            }
            followPath = getAgent().getNavigation().getPath(here, there);
        }
        if (followPath == null) {
            if (intelligence.fullLogging) {
                agent.log.info("No path found");
            }
            return;
        } else {
            String path = "";
            for (NavPoint p: followPath) {
                path += p.location.toString() + "|";
            }
            if (intelligence.fullLogging) {
                agent.log.info("Path length " + followPath.size() + ": " + path);
            }
            agent.log.info("Goal " + followPath.get(followPath.size() - 1));
        }
        while (pathCount < followPath.size() - 1) {
            try {
                getAgent().setHigherLevelGoals(followPath.get(pathCount), followPath.get(pathCount + 1));
                checkValidity();
                if ( Triple.distanceInSpace(
                        agent.getMemory().getAgentLocation(),
                        followPath.get(pathCount).location) < 200) {
                    ++pathCount;
                    if (intelligence.fullLogging) {
                        agent.log.info("Next point");
                    }
                }
                Thread.sleep(80);
            } catch (InterruptedException ex) {
                if (intelligence.fullLogging) {
                    agent.log.info("Retreating interrupted: " + ex.getMessage());    
                }
                if (getAgent().gotStuck()) {
                    setGoalUnreachable();
                }
                return;
            }
        }
        getAgent().setHigherLevelGoals(followPath.get(pathCount), null);
        // wait until the agent is really at goal location - otherwise he will
        // be starting new thoughts on the last part of path
        while ( Triple.distanceInSpace(agent.getMemory().getAgentLocation(),
                    followPath.get(pathCount).location) >= 120) {
            try {
                checkValidity();
                Thread.sleep(80);
            } catch (InterruptedException ex) {
                if (intelligence.fullLogging) {
                    agent.log.info("Retreating interrupted: " + ex.getMessage());    
                }
                if (getAgent().gotStuck()) {
                    setGoalUnreachable();
                }
                return;
            }
        }
    }
    
    private ThinkBot getAgent() {
        return (ThinkBot)agent;
    }
    
    @Override
    protected boolean valid() {
        return (Triple.distanceInSpace(followPath.get(pathCount).location,
                    getAgent().getMemory().getAgentLocation()) < 1500) && !getAgent().gotStuck();
    }
    
}